<?php
include 'db.php';

// Define default date filter (e.g., Today)
$dateFilter = "CURDATE()";

// Update date filter based on selected option
if (isset($_GET['dateRange'])) {
    switch ($_GET['dateRange']) {
        case 'yesterday':
            $dateFilter = "CURDATE() - INTERVAL 1 DAY";
            break;
        case 'last_week':
            $dateFilter = "YEARWEEK(timedate, 1) = YEARWEEK(CURDATE() - INTERVAL 1 WEEK, 1)";
            break;
        case 'last_month':
            $dateFilter = "MONTH(timedate) = MONTH(CURDATE() - INTERVAL 1 MONTH)";
            break;
        default:
            $dateFilter = "CURDATE()"; // Today
    }
}

// Modify the query to include date filter
$query = "SELECT SUM(amount * taps) AS total_sales, SUM(taps) AS total_units 
          FROM transacetion 
          WHERE delete_status = 0 AND DATE(timedate) = $dateFilter";

$result = mysqli_query($connection, $query);

$totalSales = $totalUnits = 0;
if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $totalSales = $row['total_sales'];
    $totalUnits = $row['total_units']; 
}
?>




<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>

    <!-- Bootstrap CSS Link -->
    <link rel="stylesheet" href="assests/css/bootstrap.min.css">
     <!-- Bootstrap CSS Link -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <!-- <link rel="stylesheet" href="assests/css/font.css"> -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <!-- Owl Carousel -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">

    <style>
        body {
            background-color: #fff;
            /* margin: 20px; */
            overflow-x: hidden !important;
        }

        .card {
            padding: 20px;
            background: linear-gradient(to bottom, #e2f3ff 0%, #fee1fc 100%);
            box-shadow: rgba(50, 50, 93, 0.25) 0px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;
            border-radius: 15px;
        }

        .card1 {
            padding: 20px;
            background: linear-gradient(to bottom, #eae1fe 0%, #fee1e2 100%);
            box-shadow: rgba(50, 50, 93, 0.25) 0px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;
        }

        .card2 {
            padding: 20px;
            background: #fff;
            box-shadow: rgba(50, 50, 93, 0.25) 0px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;
        }

        .card-2 {
            padding: 20px;
            background: #fff;
            /* box-shadow: rgba(50, 50, 93, 0.25) 0px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px; */
            box-shadow: rgba(180, 179, 179, 0.4) 0px 5px, rgba(175, 175, 175, 0.3) 0px 10px, rgba(158, 158, 158, 0.2) 0px 15px, rgba(141, 141, 141, 0.1) 0px 20px, rgba(129, 129, 129, 0.05) 0px 25px;
        }

        .card3 {
            padding: 30px;
            background: #fff;
            box-shadow: rgba(50, 50, 93, 0.25) 0px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;
            border-radius: 15px;
            margin-bottom: 20px;
        }

        .text-h6 {
            font-size: 12px;
            font-weight: 600;
        }

        .icon-1 {
            text-align: center;
            padding: 10px;
        }

        .fa {
            font-size: 45px;
        }

        .text-h4 {
            margin-bottom: 15px;
            font-size: 18px;
        }

        .owl-stage-outer {
            padding: 20px;
        }

        /* Swiper card */
        .cards-1 {
            width: 100%;
            padding-top: 125%;
            position: relative;
            margin-bottom: -50%;
        }

        .card-1 {
            position: absolute;
            width: 100%;
            height: 50%;
            /* background: #85144b; */
            background: linear-gradient(to bottom, #68c9f9 0%, #aba4ff 100%);
            border-radius: 50px;
            transform: scale(.9);
            top: -8%;
            transition: all .5s ease-in-out;
        }

        .card-1.card--active {
            transform: scale(1);
            top: 0;
            background: linear-gradient(to bottom, #91fac6 0%, #1e8b1d 100%);
            z-index: 100;
        }

        .card-1.card--remove {
            animation: swipe-left .5s ease-in-out both;
        }

        .card-1.card--reactivate {
            animation: swipe-right .5s ease-in-out both;
        }

        .card-1.card--inactive {
            transform: scale(.85);
            background: linear-gradient(to bottom, #204f22 0%, #5aa56a 100%);
        }

        .card-1::after {
            position: absolute;
            bottom: 20px;
            content: "";
            width: 40px;
            height: 5px;
            border-radius: 10px;
            background-color: rgba(0, 0, 0, .4);
            left: 50%;
            transform: translateX(-50%);
        }

        /* .card-1.card--1 {
            z-index: 100;
        } */

        /* .card-1.card--2 {
            background: linear-gradient(to bottom, #91fac6 0%, #1e8b1d 100%);
            z-index: 80;
        } */

        /* .card-1.card--3 {
            background: linear-gradient(to bottom, #204f22 0%, #5aa56a 100%);
            z-index: 50;
        } */
        .card-1.card--active {
    background: linear-gradient(to bottom, #91fac6 0%, #1e8b1d 100%);
    z-index: 100; /* Highest z-index */
}

.card-1.card--inactive {
    background: linear-gradient(to bottom, #204f22 0%, #5aa56a 100%);
    /* Adjusted z-index per card */
}


        @keyframes swipe-left {
            10% {
                transform: rotate(-3deg) translate3d(-5%, -2%, 0);
            }

            50% {
                transform: rotate(-7deg) translate3d(-15%, -2%, 0);
            }

            90% {
                transform: rotate(-7deg) translate3d(-150%, -2%, 0);
                opacity: .9;
            }

            100% {
                transform: rotate(-7deg) translate3d(-150%, -2%, 0);
                opacity: 0;
            }
        }

        @keyframes swipe-right {
            0% {
                transform: rotate(-7deg) translate3d(-150%, -2%, 0);
                opacity: 0;
            }

            10% {
                transform: rotate(-7deg) translate3d(-150%, -2%, 0);
                opacity: .9;
            }

            50% {
                transform: rotate(-7deg) translate3d(-15%, -2%, 0);
                opacity: 1;
            }

            90% {
                transform: rotate(-3deg) translate3d(-5%, -2%, 0);
            }

            100% {
                transform: rotate(0deg) translate3d(0, 0, 0);
            }
        }

        .card__top {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .user {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 30px;
        }

        .user__img {
            background: #f1f1f1;
            height: 40px;
            width: 40px;
            border-radius: 50%;
        }

        .user__details {
            margin-left: 10px;
        }

        .user__name {
            width: 120px;
            height: 10px;
            border-radius: 20px;
            background-color: #f3f3f3;
            margin-bottom: 10px;
        }

        .user__time {
            width: 50px;
            height: 7px;
            border-radius: 10px;
            background-color: #f6f6f6;
        }   
        .card {
            position: relative;
        }

        .card--3 {
            position: absolute; 
            z-index: 10; 
        }

        select {
            border: none;
        }

        option {
            font-size: 14px;
        }

        a {
            text-decoration: none;
        }

        .prod-img {
            background-color: #e2f3ff;
            width: 80px;
            height: 70px;
            border-radius: 50%; 
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .row-1 {
            margin-bottom: 20px;
        }

        .trans-height {
            height: 500px;
            overflow-y: scroll;
        }

        .fa-angle-down,
        .fa-angle-up {
            color: black;
            background-color: #fff;
            font-size: 20px;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            align-self: center;
            vertical-align: middle;
            line-height: 1.5;
            margin-bottom: -30px;
            /* box-shadow: rgba(50, 50, 93, 0.25) 6px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px; */
            box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;
            cursor: pointer;
        }

        .hidden-row {
            display: none;
            /* overflow: hidden !important; */
            /* transition: max-height 1s ease-in, opacity 1s ease-in; */
            /* opacity: 0; */
        }

        .show {
            /* display: block; */
            opacity: 1;
        }

        

        select:focus,
        select:hover {
            border: none !important;
        }

        .mobileview {
            display: none;
        }

        .deskview {
            display: block;
        }

        .card-img {
            width: -webkit-fill-available; 
            height: -webkit-fill-available; 
            border-radius: 20px;
        }

        body,
        .transaction-section {
            max-width: 100vh;
            overflow-y: scroll;
            position: relative;
            overflow-x: hidden;
        }
        
        /* Scrollbar */
        .transaction-section {
            --scrollbar-color-track: transparent;
            --scrollbar-color-thumb: #e2f3ff;
        }

        body {
            --scrollbar-color-track: transparent;
            /* --scrollbar-color-thumb: #0B132B; */
            --scrollbar-color-thumb: #eae1fe;
        }

        body {
            height: 100vh;
            position: relative;
            container-type: inline-size;
        }
        @supports (scrollbar-width: auto) {
            body,
            .transaction-section {
                scrollbar-color: var(--scrollbar-color-thumb) var(--scrollbar-color-track);
            }

            .warning {
                display: none;
            }
        }

        

        @media (max-width: 480px) {
            body,
            .transaction-section {
                overflow-x: hidden;
            }

            .mobileview {
                display: block;
                margin: 20px;
            }

            .deskview {
                display: none;
            }
        }

        /* Pull-in animation for about.html */
    .slideIn {
        transform: translateX(100%); /* Initial state off-screen */
        animation: slideInAnimation 0.5s forwards ease;
    }

    @keyframes slideInAnimation {
        from {
            transform: translateX(100%);
        }
        to {
            transform: translateX(0);
        }
    }
    .page__style {
        font-family: 'OpenSans-Regular', sans-serif;
        /* position: fixed; */
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        height: 100%;
        width: 100%;
        margin: auto;
        /* overflow: hidden; */
        transition: transform 0.5s ease, opacity 0.2s ease;
    }

    .styled-select {
        width: 100px;
        background-color: unset;
    }

 /* Basic styling for the modal */
 .modal {
        display: none; /* Hidden by default */
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.8);
        justify-content: center;
        align-items: center;
        z-index: 500;
    }

    /* Modal content for the image */
    .modal-content {
        max-width: 90%;
        max-height: 90%;
    }

    /* Close button styling */
    .close {
        position: absolute;
        top: 20px;
        right: 30px;
        color: #fff;
        font-size: 30px;
        font-weight: bold;
        cursor: pointer;
    }

    </style>
</head>

<body>
    <div class="">
        <h2 class="text-center deskview">Change to Mobile View</h2>
        <div class="mobileview">
            <!-- <div class="text-end">
                <a href="index.html" class="btn btn-outline-dark closeBtn text-right" id="closeBtn">X</a>
            </div> -->
            <!-- <br> -->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-8 col-md-8 col-8">
                        <h4 class="text-h4">Business Summary</h4>
                        <h6 class="text-h6" style="margin-top: -10px;">Complete business summary in a glance</h6>
                    </div>
                    <div class="col-lg-4 col-md-4 col-4 text-start">
                        <form method="get" action="">
                            <div class="dropdown">
                                <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown" id="dropdownButton">
                                    Today <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a href="#" class="dropdown-item">Today</a></li>
                                    <li><a href="#" class="dropdown-item">Yesterday</a></li>
                                    <li><a href="#" class="dropdown-item">Next Month</a></li>
                                    <li><a href="#" class="dropdown-item">Next Week</a></li>
                                </ul>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        
        <!-- Card Slaes -->
            <div class="row">
                <div class="col-md-6 col-6">
                    <div class="card">
                        <div class="card-text text-center">
                            <p>₹ Rupees</p>
                            <h4><?php echo number_format($totalSales); ?></h4>
                            <p>Total Sales</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-6">
                    <div class="card card1 text-center">
                        <div class="card-text">
                            <p>No. of units</p>
                            <h4><?php echo number_format($totalUnits); ?></h4>
                            <p>Sold Stocks</p>
                        </div>
                    </div>
                </div>
            </div>
        
            <br>
            <!-- Logo Categories -->
        
            <h4 class="text-h4">Create & Manage</h4>
        
            <div class="card card-2">
                <div class="row">
                    <div class="card-text d-flex align-items-center">
                        <div class="icon-1">
                            <!-- <i class="fa fa-box"></i><span>Products</span> -->
                            <img src="assests/images/box.png" alt="" style="width: 65px;" onclick="window.location='products.php'"><span>Products</span>
                        </div>
                        <div class="icon-1">
                            <!-- <i class="fa fa-file"></i><span>Reports</span> -->
                            <img src="assests/images/report.png" alt="" style="width: 65px;" onclick="window.location='reports.php'"><span>Reports</span>
                        </div>
                        <div class="icon-1">
                            <!-- <i class="fa fa-list-alt"></i><span>Category</span> -->
                            <img src="assests/images/categories.png" alt="" style="width: 65px;" onclick="window.location='category.php'"><span>Category</span>
                        </div>
                        <div class="icon-1">
                            <!-- <i class="fa fa-undo"></i><span>Undo</span> -->
                            <img src="assests/images/undo.png" alt="" style="width: 65px;"><span>Undo</span>
                        </div>
                    </div>
                </div>
                <div class="row hidden-row">
                    <div class="card-text d-flex align-items-center">
                        <div class="icon-1">
                            <!-- <i class="fa fa-box"></i><span>Products</span> -->
                            <img src="assests/images/box.png" alt="" style="width: 65px;"><span>Products</span>
                        </div>
                        <div class="icon-1">
                            <!-- <i class="fa fa-file"></i><span>Reports</span> -->
                            <img src="assests/images/report.png" alt="" style="width: 65px;"><span>Reports</span>
                        </div>
                        <div class="icon-1">
                            <!-- <i class="fa fa-list-alt"></i><span>Category</span> -->
                            <img src="assests/images/categories.png" alt="" style="width: 65px;"><span>Category</span>
                        </div>
                        <div class="icon-1">
                            <!-- <i class="fa fa-undo"></i><span>Undo</span> -->
                            <img src="assests/images/undo.png" alt="" style="width: 65px;"><span>Undo</span>
                        </div>
                    </div>
                </div>
                <i class="icon-copy fa fa-angle-down text-center" aria-hidden="true"></i>
            </div>
        
            <br><br>
        
            <!-- Carousel Effect -->
            <h4 class="text-h4">Reminders</h4>
            
            <div class="row">
                <div class="owl-carousel owl-themepd-20">
                    <?php 
                    $reminder = "SELECT * from reminder";
                    $reminderresult = mysqli_query($connection, $reminder);
                    ?>
                     <?php while ($row = mysqli_fetch_assoc($reminderresult)): ?>
                    <div class="card card2 item">
                       <?php echo $row['note']?>
                    </div>
                    <?php endwhile; ?>
                    <div class="card card2 item">
                        gsfdg
                    </div>
                    <div class="card card2 item">
                        gsfdg
                    </div>
                    <div class="card card2 item">
                        gsfdg
                    </div>
                    <div class="card card2 item">
                        gsfdg
                    </div>
                    <div class="card card2 item">
                        gsfdg
                    </div>
                </div>
            </div>
        
            <!-- Swiper card -->
            <!-- https://codepen.io/faarda/pen/YzwbJOV -->
            <h4 class="text-h4">Essential Documents</h4>
            <br>
            <div class="cards-1">
                    <?php 
                        $documents = "SELECT * FROM documents";
                        $documentresult = mysqli_query($connection, $documents);
                        $rows = mysqli_fetch_all($documentresult, MYSQLI_ASSOC); // Fetch all rows as an array

                        foreach ($rows as $index => $row):
                            // Add 'card--active' to the first card, 'card--inactive' to the rest
                            $activeClass = ($index === 0) ? 'card--active' : 'card--inactive';
                            ?>
                            <div class="card-1 <?php echo $activeClass; ?>" style="z-index: <?php echo 100 - ($index * 10); ?>;">
                            <img src="<?php echo $row['documentimage']; ?>" class="card-img" alt="<?php echo $row['documentname']; ?>" onclick="openModal('<?php echo $row['documentimage']; ?>')">
                            </div>
                        <?php endforeach; ?>
                </div>

                <div id="imageModal" class="modal">
    <span class="close" onclick="closeModal()">&times;</span>
    <img class="modal-content" id="modalImage">
</div>
        
            <!-- Recents -->
        
            <div class="transaction-section">
                <div class="row">
                    <div class="col-md-6 col-6">
                        <h4 class="text-h4">Recent Transactions</h4>
                    </div>
                    <div class="col-md-6 col-6 text-end">
                        <a href="">view all</a>
                    </div>
                </div>
            
                <div class="card3 trans-height">
                <?php 
                    include 'db.php';

                    // Query to join transacetion with product table to get product name and image
                    $recentTrans = "
                         SELECT t.*, p.productname, p.productimage
                        FROM transacetion AS t
                        INNER JOIN product AS p ON t.productid = p.id
                        WHERE t.delete_status = 0
                        ORDER BY t.timedate DESC
                        LIMIT 5
                    ";
                    $result = mysqli_query($connection, $recentTrans);
                    ?>

                    <!-- Display transactions in a loop -->
                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                        <div class="row d-flex align-items-center row-1">
                            <!-- Product Image -->
                            <img src="<?php echo $row['productimage']; ?>" class="col-md-4 col-4 prod-img" alt="<?php echo $row['seotitle'];?>" title="<?php echo $row['seodescription'];?>">
                            
                            <!-- Product Details -->
                            <div class="prod-text col-md-6 col-6">
                                <p><b><?php echo $row['productname']; ?></b></p>
                                <p><?php echo date('H:i:s', strtotime($row['timedate'])); ?> &nbsp;&nbsp;<span>
                                    <?php echo (date('Y-m-d') == date('Y-m-d', strtotime($row['timedate']))) ? 'Today' : date('Y-m-d', strtotime($row['timedate'])); ?>
                                </span></p>
                            </div>
                            
                            <!-- Quantity Sold -->
                            <div class="col-md-2 col-2">
                                <p class="num"><b><?php echo $row['taps']; ?></b></p>
                            </div>
                        </div>
                    <?php endwhile; ?>

                 
                    
                </div>
            </div>
        </div>
    </div>
    
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://hammerjs.github.io/dist/hammer.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/hammerjs@2.0.8/hammer.min.js"></script>

    <script>
        // jQuery(".owl-carousel").owlCarousel({
        //     autoplay: true,
        //     rewind: false, 
        //     margin: 20,
        //     loop: true,
        //     responsiveClass: true,
        //     autoHeight: true,
        //     autoplayTimeout: 7000,
        //     smartSpeed: 800,
        //     nav: false,
        //     responsive: {
        //         0: {
        //         items: 3
        //         },

        //         600: {
        //         items: 3
        //         },

        //         1024: {
        //         items: 6
        //         },

        //         1366: {
        //         items: 6
        //         }
        //     }
        // });

        $(document).ready(function(){
            $(".owl-carousel").owlCarousel({
                items: 3,
                loop: true,
                margin: 10,
                autoplay: true,
                autoplayTimeout: 2000,
                autoplayHoverPause: true
            });
        });
    </script>
     


     <script>
    document.addEventListener('DOMContentLoaded', () => {
        const cards = [...document.querySelectorAll('.card-1')];
        const lastCardIndex = cards.length - 1;

        cards.forEach((card, index) => {
            const mc = new Hammer(card);

            // Enable all swipe directions
            mc.get('swipe').set({
                direction: Hammer.DIRECTION_ALL,
                threshold: 1,
                velocity: 0.1
            });

            // Listen to swipe events
            mc.on('swipeleft swiperight', (ev) => handleSwipe(ev, index));
        });

        function handleSwipe(ev, index) {
            // Skip swipe left actions for the last card
            if (index === lastCardIndex && ev.type === 'swipeleft') {
                return;
            }

            if (ev.type === 'swipeleft') {
                // Handle swipe left
                if (index < cards.length - 1) {
                    cards[index].classList.add('card--remove');
                    cards[index + 1].classList.add('card--active');
                    cards[index + 1].classList.remove('card--inactive'); // Remove inactive class from the card being activated
                    if (index < cards.length - 2) {
                        cards[index + 2].classList.remove('card--inactive');
                    }
                }
            } else if (ev.type === 'swiperight') {
                // Handle swipe right
                if (index > 0) {
                    cards[index - 1].classList.remove('card--remove');
                    cards[index - 1].classList.add('card--reactivate');

                    setTimeout(() => {
                        cards[index - 1].classList.remove('card--reactivate');
                    }, 1000);

                    cards[index].classList.remove('card--active');
                    cards[index].classList.add('card--inactive'); // Make sure to add 'inactive' to the current card when it becomes inactive

                    if (index < cards.length - 1) {
                        cards[index + 1].classList.add('card--inactive');
                    }
                }
            }
        }
    });

    
</script>
<script>
    // Function to open the modal and display the clicked image
    function openModal(imageSrc) {
        const modal = document.getElementById("imageModal");
        const modalImage = document.getElementById("modalImage");

        modalImage.src = imageSrc; // Set the modal image to the clicked image source
        modal.style.display = "flex"; // Show the modal
    }

    // Function to close the modal
    function closeModal() {
        const modal = document.getElementById("imageModal");
        modal.style.display = "none"; // Hide the modal
    }

    // Close the modal when clicking outside the image
    window.onclick = function(event) {
        const modal = document.getElementById("imageModal");
        if (event.target === modal) {
            closeModal();
        }
    };
</script>
    <script>
        // $(document).ready(function(){
        //     $('.fa-angle-down').on('click', function() {
        //         $('.hidden-row').toggleClass('show');
        //     });
        // });

        $(document).ready(function() {
            $('.fa-angle-down').on('click', function() {
                var $hiddenRow = $('.hidden-row');

                if ($hiddenRow.is(':visible')) {
                    $hiddenRow.slideUp(500); // Slide up slowly to hide
                    $(this).removeClass('fa-angle-up').addClass('fa-angle-down');
                } else {
                    $hiddenRow.slideDown(500); // Slide down slowly to show
                    $(this).removeClass('fa-angle-down').addClass('fa-angle-up');
                }
            });
        });
    </script>

</body>
</html>